//=============================================================================
// AmmoShell.
//=============================================================================
class AmmoCombatRifle extends DeusExAmmo;

var travel int NumProjectiles;
var travel string Special, VSBonus;
var travel int Caliber;
var travel string CustomName;

#exec MESH IMPORT MESH=CombatRifleAmmo ANIVFILE=MODELS\CombatRifleAmmo2_a.3d DATAFILE=MODELS\CombatRifleAmmo2_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=CombatRifleAmmo X=0 Y=0 Z=0 PITCH=0 ROLL=64 YAW=0

#exec MESH SEQUENCE MESH=CombatRifleAmmo SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=CombatRifleAmmo SEQ=CombatRifleAmmo STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=CombatRifleAmmo MESH=CombatRifleAmmo
#exec MESHMAP SCALE MESHMAP=CombatRifleAmmo X=0.008594025 Y=0.008594025 Z=0.008594025

#exec TEXTURE IMPORT FILE="Textures\CBAGray.pcx"	NAME="CRAGray"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\CBABlack.pcx"	NAME="CRABlack"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\CBAGold.pcx"	NAME="CRAGold"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\CBADGold.pcx"	NAME="CRADGold"	GROUP="Icons" MIPS=Off

#exec MESHMAP SETTEXTURE MESHMAP=CombatRifleAmmo NUM=0 TEXTURE=CRAGray
#exec MESHMAP SETTEXTURE MESHMAP=CombatRifleAmmo NUM=1 TEXTURE=CRABlack
#exec MESHMAP SETTEXTURE MESHMAP=CombatRifleAmmo NUM=2 TEXTURE=CRAGold
#exec MESHMAP SETTEXTURE MESHMAP=CombatRifleAmmo NUM=3 TEXTURE=CRADGold


#exec TEXTURE IMPORT FILE="Textures\IconAmmoCombatRifle2.pcx"	NAME="CombatRifleAmmo"	GROUP="Icons" MIPS=Off FLAGS=2


simulated function String FormatFloatString(float value, float precision)
{
	local string str;

	if (precision == 0.0)
		return "ERR";

	// build integer part
	str = String(Int(value));

	// build decimal part
	if (precision < 1.0)
	{
		value -= Int(value);
		str = str $ "." $ String(Int((0.5 * precision) + value * (1.0 / precision)));
	}

	return str;
}

function UpdateName()
{
 ItemName = FormatFloatString(  float(Caliber) / 100, 0.01  )$"mm"@CustomName@"Rounds";
 Description = "Caliber:"@FormatFloatString(  float(Caliber) / 100, 0.01  )$"mm|nSpread:"@NumProjectiles@"Shot(s)|nSpecial Effects:"@Special$"|n+VS:"@VSBonus;
 if (CustomName ~= "Standard") BeltDescription = FormatFloatString(  float(Caliber) / 100, 0.01  )$"mm";
 else BeltDescription = CAPS(CustomName);
}

function PostBeginPlay()
{
 Super.PostBeginPlay();
 
 UpdateName();
}

function TravelPostAccept()
{
 Super.TravelPostAccept();
 
 UpdateName();
}

function bool HandlePickupQuery( inventory Item )
{
	local AmmoCombatRifle A;

	if (item.IsA('AmmoCombatRifle')) A = AmmoCombatRifle(Item);

       if (A != None && (  A.NumProjectiles != Self.NumProjectiles || A.Special != Self.Special || A.Caliber != Self.Caliber || A.CustomName != Self.CustomName || A.VSBonus != Self.VSBonus )  )
	return false;

       else
	return Super.HandlePickupQuery(Item);
}

function bool UseAmmo(int AmountNeeded)
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing shell;
	local DeusExWeapon W;

	if (Super.UseAmmo(AmountNeeded))
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;

		// use silent shells if the weapon has been silenced
		W = DeusExWeapon(Pawn(Owner).Weapon);
      if ((DeusExMPGame(Level.Game) != None) && (!DeusExMPGame(Level.Game).bSpawnEffects))
      {
         shell = None;
      }
      else
      {
         if ((W != None) && ((W.NoiseLevel < 0.1) || (W.bHasSilencer && CustomRifle(W).bUsingSilencer == False) ))
            shell = spawn(class'ShellCasingSilent',,, Owner.Location + offset);
         else
            shell = spawn(class'ShellCasing',,, Owner.Location + offset);
      }

		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}

	return False;
}

defaultproperties
{
     bShowInfo=True
     AmmoAmount=30
     MaxAmmo=99999
     ItemName="Assault Rifle Rounds"
     ItemArticle="some"
     PickupViewMesh=LodMesh'CombatRifleAmmo'
     Icon=Texture'CombatRifleAmmo'
     largeIconWidth=0
     largeIconHeight=0
     Description=""
     beltDescription=""
     Mesh=LodMesh'CombatRifleAmmo'
     CollisionRadius=4.000000
     CollisionHeight=1.000000
     bCollideActors=True
     NumProjectiles=1
     Special=""
     Caliber=556
}
